---
title: Cloudflare Cache · Cloudflare Cache (CDN) docs
description: Cache stores copies of frequently accessed content (such as images,
  videos, or webpages) in geographically distributed data centers that are
  located closer to end users than origin servers, reducing server load and
  improving website performance.
lastUpdated: 2025-11-19T12:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cache/
  md: https://developers.cloudflare.com/cache/index.md
---

Cache content across Cloudflare's global server network.

Available on all plans

Cache stores copies of frequently accessed content (such as images, videos, or webpages) in geographically distributed data centers that are located closer to end users than origin servers, reducing server load and improving website performance.

## Features

### Default cache behavior

Learn about default cache behavior, default cached file extensions and cache responses.

[Use Default cache behavior](https://developers.cloudflare.com/cache/concepts/default-cache-behavior/)

### Cache Rules

Configure Cache Rules to optimize your website by specifying which resources should be cached and for how long.

[Use Cache Rules](https://developers.cloudflare.com/cache/how-to/cache-rules/)

### Tiered Cache

Enable Tiered Cache to optimize content delivery by caching frequently accessed content in multiple locations for faster delivery and reduced origin traffic.

[Use Tiered Cache](https://developers.cloudflare.com/cache/how-to/tiered-cache/)

### Cache Reserve

Use Cloudflare's persistent storage to increase cache times.

[Use Cache Reserve](https://developers.cloudflare.com/cache/advanced-configuration/cache-reserve/)

### Purge

Instantly purge cached files to force Cloudflare to fetch fresh versions from your web server files. You can purge specific files or all at once.

[Use Purge](https://developers.cloudflare.com/cache/how-to/purge-cache/)

***

## Related products

**[Load Balancing](https://developers.cloudflare.com/load-balancing/)**

Cloudflare Load Balancing distributes traffic across your endpoints, reducing endpoint strain and latency and improving the end users experience.

**[Images](https://developers.cloudflare.com/images/)**

A suite of products tailored to your image-processing needs.

**[Workers](https://developers.cloudflare.com/workers/)**

Cloudflare Workers allows developers to build serverless applications and deploy instantly across the globe for exceptional performance, reliability, and scale.

**[Rules](https://developers.cloudflare.com/rules/)**

Cloudflare Rules allows you to make adjustments to requests and responses, configure Cloudflare settings, and trigger specific actions for matching requests.

**[Cloudflare Network Interconnect](https://developers.cloudflare.com/network-interconnect/)**

Cloudflare Network Interconnect (CNI) allows you to connect your network infrastructure directly with Cloudflare – rather than using the public Internet – for a more reliable and secure experience.

**[R2](https://developers.cloudflare.com/r2/)**

Cloudflare R2 Storage allows developers to store large amounts of unstructured data without the costly egress bandwidth fees associated with typical cloud storage services.

**[Dedicated CDN Egress IPs](https://developers.cloudflare.com/smart-shield/configuration/dedicated-egress-ips/)**

Smart Shield Advanced provides dedicated egress IPs (from Cloudflare to your origin) for your layer 7 WAF and CDN services, as well as Spectrum.

***

## More resources

[Plans](https://www.cloudflare.com/cdn/)

Compare available Cloudflare plans

[Pricing](https://www.cloudflare.com/plans/#overview)

Explore pricing options for Cache
