---
title: Ubiquiti · Cloudflare One docs
description: Connect a Ubiquiti UniFi Gateway to Cloudflare's network using
  Magic WAN. These steps use the Cloud Gateway Max (UCG-Max) but work with other
  UniFi gateways supporting route-based IPsec VPNs, like the Dream Machine
  series.
lastUpdated: 2025-11-19T12:29:18.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/third-party/ubiquiti/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/third-party/ubiquiti/index.md
---

Connect a Ubiquiti UniFi Gateway to Cloudflare's network using Magic WAN. These steps use the Cloud Gateway Max (UCG-Max) but work with other UniFi gateways supporting route-based IPsec VPNs, like the Dream Machine series.

## Prerequisites

* Cloudflare account with Magic WAN enabled (contact your account team)

* UniFi Cloud Gateway or Dream Machine with IPsec support

* UniFi Network Application (self-hosted or cloud)

* Static public IP from your ISP

* Admin access to both Cloudflare and UniFi

* Gather a **Magic Anycast IPv4** address from the **Leased IPs** section in the dashboard

  * [Go to **Leased IPs**](https://dash.cloudflare.com/?to=/:account/ip-addresses/leased-ips)
  * Contact your account team if you do not see any IPs listed.

## 1. Configure Magic WAN

1. Log in to [Cloudflare One](https://one.dash.cloudflare.com/), and go to **Networks**.
2. Go to **Connectors** > **WAN Tunnels**, and select **Create**.

1) Select **IPsec tunnel** > **Next**, and fill in the following settings:

   * **Name**: `unifi-gw-primary`

   * **IPv4 Interface Address**: `10.252.2.28/31` or refer to the [Tunnel endpoints documentation](https://developers.cloudflare.com/magic-wan/configuration/manually/how-to/configure-tunnel-endpoints/)

   * **Customer Endpoint**: This should be your UniFi Gateway's WAN IP (for example, `203.0.113.10`)

   * **Cloudflare Endpoint**: This should be one of the IPv4 addresses gathered from Leased IPs.

   * Under **Tunnel Health checks**, select:

     * **Health check rate**: Set to desired level
     * **Health check type**: *Request*
     * **Health check direction**: *Bidirectional*
     * **Health check target**: *Default*

   * Under **Pre-shared key**:
     * Select **Add pre-shared key later**. This key will be given during the UniFi site-to-site VPN configuration.

## 2. Configure site-to-site VPN on UniFi

1. In UniFi Network, go to **Settings** > **VPN** > **Site-to-Site VPN**.

2. Select **Create New**.

3. Configure the following settings:

   * **VPN Type:** `IPsec`.
   * **Name:** `Cloudflare-Magic-WAN`.
   * **Pre-shared key:** Copy this key. You need it for the Magic WAN tunnel.
   * **Local IP:** Select the WAN interface (for example, `WAN1`).
   * **Remote IP:** Enter the Cloudflare endpoint IP from [Step 1](#1-configure-magic-wan).
   * **VPN Method:** Route Based.
   * **Tunnel IP:** `10.252.2.29/31` or refer to the [Tunnel endpoints documentation](https://developers.cloudflare.com/magic-wan/configuration/manually/how-to/configure-tunnel-endpoints/).
   * **Remote Networks:** Inside Cloudflare tunnel address (for example, `10.252.2.28/31`) and other remote subnets to access through Magic WAN.

4. Set Advanced settings:

   * **Key Exchange Version**: IKEv2.
   * **IKE Encryption**: AES-256.
   * **IKE Hash**: SHA256.
   * **IKE DH Group**: 14.
   * **IKE Lifetime**: 28800.
   * **ESP Encryption**: AES-256.
   * **ESP Hash**: SHA256.
   * **ESP DH Group**: 14.
   * **ESP Lifetime**: 28800.
   * **PFS**: Enabled.
   * **Local Authentication ID**: Auto.
   * **Remote Authentication ID**: Uncheck **Auto**, and enter the Cloudflare Endpoint IP from [Step 1](#1-configure-magic-wan).
   * **MTU**: 1436.

5. Select **Apply**

## 3. Add pre-shared key to Cloudflare

1. Log in to [Cloudflare One](https://one.dash.cloudflare.com/), and go to **Networks**.
2. In **WAN tunnels**, find the IPsec tunnel you have just created.

1) Select your tunnel and then **Edit**.
2) Paste the preshared key from [Step 2](#2-configure-site-to-site-vpn-on-unifi).
3) Select **Save**.

## 4. Configure Routes

1. Log in to [Cloudflare One](https://one.dash.cloudflare.com/), and go to **Networks**.
2. Go to **Routes** > **WAN routes** > **Create**.

1) Enter the following settings:

   * **Prefix**: Your local network (for example, `192.168.1.0/24`).
   * **Tunnel/Next hop**: Select your tunnel.
   * **Priority**: `100`.

2) Select **Add routes** to add your static route.

## Verify connections

To check your connections are working correctly, wait a few minutes, and then access both Cloudflare and UniFi to verify the tunnel's status:

Cloudflare

1. Log in to [Cloudflare One](https://one.dash.cloudflare.com/), and go to **Insights**.
2. Go to **Network visibility** > **WAN connector health**.
3. Find the tunnel you have just created and make sure its status shows **Up**. Refer to [Check tunnel health in the dashboard](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/common-settings/check-tunnel-health-dashboard/) for more information.

UniFi

Go to **Settings** > **VPN**, and make sure the status is **Connected**.

## Troubleshooting

**Tunnel down:**

* Verify Peer IP, pre-shared key, and IPsec settings match on both sides
* Check that the ISP is not blocking UDP ports `500`/`4500`

**Traffic not routing:**

* Verify Remote Subnets setting in UniFi VPN configuration
* Check firewall rules are not blocking VPN traffic

**Health check fails:**

* Allow ICMP from Cloudflare to the customer-side tunnel IP
* Target should be the `/31` interface IP, not your LAN gateway

## Policy-based routing

To route only specific devices through Cloudflare (UniFi Network Application):

1. Remove necessary routes from Remote Subnets in your VPN configuration.

2. Go to **Settings** > **Policy Table**.

3. Under **Policy Engine** select **Create New Policy** with the following settings:

   * Select `Route`.
   * **Name**: Provide a name for the policy.
   * **Type**: *Policy-Based*.
   * **Interface/VPN Tunnel**: Select the VPN Tunnel (for example, `Cloudflare-Magic-WAN`).
   * **Kill Switch**: *Enabled* (recommended).
   * **Source**: Select `Device/Network` and then choose the Device(s) or Network(s).
   * **Destination**: *Any*.
   * **Interface**: Your VPN tunnel.

## Next Steps

* Use [Magic Firewall](https://developers.cloudflare.com/magic-firewall/) for network policies.
* Configure a second tunnel for redundancy.
* Monitor traffic in the Magic WAN dashboard.

***

You are now routing traffic through Cloudflare's network using Magic WAN.
