---
title: Get Origin CA keys · Cloudflare Fundamentals docs
description: Origin CA keys are often used as the value of header
  X-AUTH-USER-SERVICE-KEY when interacting with Origin CA certificates API. It
  is also used by Keyless SSL key server.
lastUpdated: 2025-09-15T14:53:30.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/api/get-started/ca-keys/
  md: https://developers.cloudflare.com/fundamentals/api/get-started/ca-keys/index.md
---

Origin CA keys are often used as the value of header `X-AUTH-USER-SERVICE-KEY` when interacting with [Origin CA certificates](https://developers.cloudflare.com/ssl/origin-configuration/origin-ca/) API. It is also used by [Keyless SSL](https://developers.cloudflare.com/ssl/keyless-ssl/) key server.

Note

You can also interact with the [Origin CA certificates API](https://developers.cloudflare.com/ssl/origin-configuration/origin-ca/#api-calls) using an [API token](https://developers.cloudflare.com/fundamentals/api/get-started/create-token/) with **Permissions** that include `Zone`-`SSL and Certificates`-`Edit`.

The key value always starts with `v1.0-`.

## Limitations

* Changing the Origin CA key is not recorded by [Audit Logs](https://developers.cloudflare.com/fundamentals/account/account-security/review-audit-logs/).
* Each time you view the Origin CA key, it will be presented as a different value. All these different values are **simultaneously valid** until you click the `Change` button, which immediately invalidates all previously generated values.
* Origin CA keys have access to every account the user has access to.

## View/Change your Origin CA keys

To retrieve your Origin CA keys:

1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com).

   [Go to **Account home**](https://dash.cloudflare.com/?to=/:account/home)

2. Go to **User Profile** > **API Tokens**.

3. In the **API Keys** section, select `Origin CA Key`.
