---
title: Connection forwarding · Cloudflare Smart Shield docs
description: Since IPv6 address ranges are deployed globally, no forwarding is needed.
lastUpdated: 2025-11-19T12:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/smart-shield/configuration/dedicated-egress-ips/how-it-works/connection-forwarding/
  md: https://developers.cloudflare.com/smart-shield/configuration/dedicated-egress-ips/how-it-works/connection-forwarding/index.md
---

Since IPv6 address ranges are deployed globally, no forwarding is needed.

For IPv4 traffic, based on [IPs allocation](https://developers.cloudflare.com/smart-shield/configuration/dedicated-egress-ips/how-it-works/egress-ips/#ips-allocation), not all egress data centers will have access to an applicable dedicated CDN egress IP.

Dedicated CDN egress IPs do not forward to another location in response to traffic spikes. Instead, each IPv4 can be split across up to four locations, where some of these locations may have multiple data centers. IP capacity in each data center can also be adjusted in accordance with the amount of traffic that reaches each location.

After a request reaches Cloudflare on an ingress data center, and the cache service sends a request for the egress router to connect to your origin, the following scenarios are possible.

### Traffic can egress from the same server

If the server running the egress router has access to an applicable dedicated CDN egress IP, traffic egresses from that server.

```mermaid
flowchart LR
        accTitle: Dedicated CDN Egress IPs and connection forwarding
        accDescr: Diagram showing IPv4 connection forwarding for Dedicated CDN Egress IPs - Same data center.
        A[Client]
        subgraph Data center A
        X[(Cache service)] --> B[(Egress router <br/> <small>*has applicable IP</small>)]
        end
        C[(Origin server)]

        A --ingress--> X
        B --egress--> C
```

### Connection forwarding is needed

If the server does not have access to an applicable IP, the following options are checked and the first that is possible will take place:

* Another server in the same data center has access to an applicable IP and the connection is forwarded to that server.

```mermaid
flowchart LR
        accTitle: Dedicated CDN Egress IPs and connection forwarding
        accDescr: Diagram showing IPv4 connection forwarding for Dedicated CDN Egress IPs - Same data center.
        A[Client]
        subgraph Data center A
        X[(Cache service)] --> B[(Egress router <br/> <small>*no applicable IP</small>)]
        B --> Y[(Egress server <br/> <small>*has applicable IP</small>)]
        end
        C[(Origin server)]

        A --ingress--> X
        Y --egress--> C
```

* Another data center in the same location has access to an applicable IP and the connection is forwarded to that data center.

```mermaid
flowchart LR
        accTitle: Dedicated CDN Egress IPs and connection forwarding
        accDescr: Diagram showing IPv4 connection forwarding for Dedicated CDN Egress IPs - Different data center.
        A[Client]
        subgraph Location 1
        subgraph Data center A
        X[(Cache service)] --> B[(Egress router <br/> <small>*no applicable IP</small>)]
        end
        subgraph Data center B
        B --> Y[(Egress server <br/> <small>*has applicable IP</small>)]
        end
        end
        C[(Origin server)]


        A --ingress--> X
        Y --egress--> C
```

* Another data center in a different location has access to an applicable IP. The closest location is selected and connection is forwarded to that location.

```mermaid
flowchart LR
        accTitle: Dedicated CDN Egress IPs and connection forwarding
        accDescr: Diagram showing IPv4 connection forwarding for Dedicated CDN Egress IPs - Different location.
        A[Client]
        subgraph Location 1
          subgraph Data center A
          X[(Cache service)] --> B[(Egress router <br/> <small>*no applicable IP</small>)]
          end
        end
        subgraph Location 2
          subgraph Data center C
            B --> Y[(Egress server <br/> <small>*has applicable IP</small>)]
          end
        end
        C[(Origin server)]


        A --ingress--> X
        Y --egress--> C
```
